/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.state;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.HLEModuleManager;
import jpcsp.hardware.Battery;
import jpcsp.hardware.Wlan;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class State
implements IState {
    public static Logger log = Logger.getLogger((String)"state");
    private static final int STATE_VERSION = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String fileName) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(fileName);
        GZIPInputStream gzipInputStream = new GZIPInputStream(fileInputStream);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(gzipInputStream);
        StateInputStream stream = new StateInputStream(bufferedInputStream);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Reading state from file '%s'", fileName));
        }
        try {
            this.read(stream);
            if (stream.read() >= 0) {
                log.error((Object)String.format("State file '%s' containing too much data", fileName));
            }
        }
        finally {
            stream.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Done reading state from file '%s'", fileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String fileName) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(fileName);
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(fileOutputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(gzipOutputStream);
        StateOutputStream stream = new StateOutputStream(bufferedOutputStream);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Writing state to file '%s'", fileName));
        }
        try {
            this.write(stream);
        }
        finally {
            stream.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Done writing state to file '%s'", fileName));
        }
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        Emulator.getClock().read(stream);
        Wlan.read(stream);
        Battery.read(stream);
        Emulator.getProcessor().read(stream);
        Emulator.getMemory().read(stream);
        HLEModuleManager.getInstance().read(stream);
        if (RuntimeContextLLE.isLLEActive()) {
            RuntimeContextLLE.read(stream);
            RuntimeContextLLE.createMMIO();
            RuntimeContextLLE.getMMIO().read(stream);
            RuntimeContextLLE.getMediaEngineProcessor().read(stream);
            RuntimeContextLLE.getMediaEngineProcessor().getMEMemory().read(stream);
        }
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        Emulator.getClock().write(stream);
        Wlan.write(stream);
        Battery.write(stream);
        Emulator.getProcessor().write(stream);
        Emulator.getMemory().write(stream);
        HLEModuleManager.getInstance().write(stream);
        if (RuntimeContextLLE.isLLEActive()) {
            RuntimeContextLLE.write(stream);
            RuntimeContextLLE.createMMIO();
            RuntimeContextLLE.getMMIO().write(stream);
            RuntimeContextLLE.getMediaEngineProcessor().write(stream);
            RuntimeContextLLE.getMediaEngineProcessor().getMEMemory().write(stream);
        }
    }
}

